
// to query the swf anti cache.
function srs_get_version_code() { return "1.33"; }

/**
* player specified size.
*/
function srs_get_player_modal() { return 100; }
function srs_get_player_width() { return srs_get_player_modal() - 30; }
function srs_get_player_height() { return srs_get_player_width() * 9 / 19; }

/**
* update the navigator, add same query string.
*/
function update_nav() {
    $("#srs_index").attr("href", "index.html" + window.location.search);
    $("#nav_rtc_publisher").attr("href", "rtc_publisher.html" + window.location.search);
}

// Special extra params, such as auth_key.
function user_extra_params(query, params) {
    var queries = params || [];

    for (var key in query.user_query) {
        if (key === 'app' || key === 'autostart' || key === 'dir'
            || key === 'filename' || key === 'host' || key === 'hostname'
            || key === 'http_port' || key === 'pathname' || key === 'port'
            || key === 'server' || key === 'stream' || key === 'buffer'
            || key === 'schema' || key === 'vhost' || key === 'api'
        ) {
            continue;
        }

        if (query[key]) {
            queries.push(key + '=' + query[key]);
        }
    }

    return queries;
}

function is_default_port(schema, port) {
    return (schema === 'http' && port === 80)
        || (schema === 'https' && port === 443)
        || (schema === 'webrtc' && port === 1985)
        || (schema === 'rtmp' && port === 1935);
}

function build_default_rtc_url(query) {
    // The format for query string to overwrite configs of server.
    console.log('?eip=x.x.x.x to overwrite candidate. 覆盖服务器candidate(外网IP)配置');

    var server = (!query.server)? window.location.hostname:query.server;
    var vhost = (!query.vhost)? window.location.hostname:query.vhost;
    var app = (!query.app)? "live":query.app;
    var stream = (!query.stream)? "livestream":query.stream;
    var api = query.api? ':'+query.api : '';

    var queries = [];
    if (server !== vhost && vhost !== "__defaultVhost__") {
        queries.push("vhost=" + vhost);
    }
    if (query.schema && window.location.protocol !== query.schema + ':') {
        queries.push('schema=' + query.schema);
    }
    queries = user_extra_params(query, queries);

    var uri = "webrtc://" + server + api + "/" + app + "/" + stream + "?" + queries.join('&');
    while (uri.lastIndexOf("?") === uri.length - 1) {
        uri = uri.substr(0, uri.length - 1);
    }

    return uri;
};

function srs_init_rtc(id, query) {
    update_nav();
    $(id).val(build_default_rtc_url(query));
}
